/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.toolkit.designer.properties.VWSIMPropertyData;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMDesignerMapPane;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMDesignerMapToolbar;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMDesignerWorkflowScrollPane;
import filenet.vw.api.VWMapDefinition;
import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWSessionInfo;
import filenet.vw.toolkit.utils.VWStepUtils;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.mapui.VWBaseMapToolbar;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowMapPane;
import filenet.vw.toolkit.utils.mapui.VWBaseWorkflowPane;
import filenet.vw.toolkit.utils.mapui.VWMapAttribs;
import filenet.vw.toolkit.utils.mapui.VWWorkflowScrollPane;
import filenet.vw.toolkit.utils.table.VWQuickSort;
import java.util.Vector;

class VWSIMDesignerWorkflowPane
extends VWBaseWorkflowPane {
    private VWSIMPropertyData m_propertyData = null;

    public VWSIMDesignerWorkflowPane(VWSIMPropertyData propertyData) {
        this.m_propertyData = propertyData;
        this.init(this.m_propertyData.getToolbarActionNotifier());
        this.m_propertyData.getSelectionChangeEventNotifier().addItemListener(this);
    }

    public String[] getCallerMaps(String currentMapName) {
        Object[] callerMapNames = null;
        try {
            VWMapDefinition[] mapDefs;
            if (this.m_workflowDefinition != null && (mapDefs = this.m_workflowDefinition.getMaps()) != null && mapDefs.length > 0) {
                int i;
                Vector<String> mapNames = new Vector<String>();
                for (i = 0; i < mapDefs.length; ++i) {
                    VWMapNode[] mapNodes = mapDefs[i].getSteps();
                    if (mapNodes == null || mapNodes.length <= 0) continue;
                    for (int j = 0; j < mapNodes.length; ++j) {
                        int stepType = VWStepUtils.getStepType(mapNodes[j]);
                        if (stepType != 9 && stepType != 10 && stepType != 11 && stepType != 12 || (callerMapNames = VWStepUtils.getCalledMapNames(mapNodes[j])) == null || callerMapNames.length <= 0) continue;
                        for (int k = 0; k < callerMapNames.length; ++k) {
                            if (VWStringUtils.compare((String)callerMapNames[k], currentMapName) != 0) continue;
                            boolean bFound = false;
                            if (mapNames.size() > 0) {
                                String name = mapDefs[i].getName();
                                for (int l = 0; l < mapNames.size(); ++l) {
                                    if (VWStringUtils.compare((String)mapNames.elementAt(l), name) != 0) continue;
                                    bFound = true;
                                    break;
                                }
                                if (bFound) continue;
                                mapNames.addElement(name);
                                continue;
                            }
                            mapNames.addElement(mapDefs[i].getName());
                        }
                    }
                }
                if (mapNames.size() > 0) {
                    callerMapNames = new String[mapNames.size()];
                    mapNames.copyInto(callerMapNames);
                    if (callerMapNames.length > 1) {
                        for (i = 0; i < callerMapNames.length; ++i) {
                            if (VWStringUtils.compare((String)callerMapNames[i], "Workflow") != 0) continue;
                            if (i == 0) break;
                            callerMapNames[i] = callerMapNames[0];
                            break;
                        }
                    }
                    VWQuickSort quicksort = new VWQuickSort(callerMapNames, 0);
                    quicksort.sort(1, callerMapNames.length - 1);
                } else {
                    callerMapNames = null;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return callerMapNames;
    }

    public VWSessionInfo getSessionInfo() {
        if (this.m_propertyData != null) {
            return this.m_propertyData.getSessionInfo();
        }
        return null;
    }

    protected VWBaseMapToolbar newMapToolbar() {
        if (this.m_mapToolbar != null) {
            return this.m_mapToolbar;
        }
        return new VWSIMDesignerMapToolbar(this);
    }

    protected VWBaseWorkflowMapPane newMapPane() {
        return new VWSIMDesignerMapPane(this);
    }

    protected VWWorkflowScrollPane newScrollPane() {
        return new VWSIMDesignerWorkflowScrollPane();
    }

    protected VWMapAttribs newMapAttributes() {
        if (this.m_mapAttribs == null) {
            this.m_mapAttribs = new VWMapAttribs(this);
        }
        return this.m_mapAttribs;
    }
}

